function [skt]=udpprogip(skt,newip,newnetmask)
%function [skt]=udpprogip(skt,newip,newnetmask)
%udpprogip(skt,'192.168.1.5')
% updated for octave 4-Feb-2018 - Ian Stothers
% Serial bits added
% 10-June- 2023 - Ian Stothers
% 2-Nov-2024 - updated for serial issues Ian Stothers
% 2-Nov-2024 - updated for netmask change Ian Stothers

[oldconfig,add]=udpget(skt,'IPConfigF'); % get the oldconfig and address

rip=ip2uint8(newip);


%   ac=[192 168 19 99   255 255 255 0   192 168 1 100    192 168 1 100     169 254 1 1             0 4 163 0 0          53];
    ac=[rip             oldconfig(5:8)  oldconfig(9:12)  oldconfig(13:16)  oldconfig(17:20)        0 4 163 0 rip(end-1) rip(end)];
    if(nargin==3)
      ac(5:8)=ip2uint8(newnetmask);
    end

    msac=max(size(ac));
    non_ip_config=max(size(oldconfig))-msac;
    ac=[ac oldconfig((msac+1):end)];
    udpprogflash(skt,add,ac);
    udpreset(skt);

    pause(1);
    if (max(size(find(skt.ip=='.')))==1)
      ipidx=find(newip=='.');
      skt.ip=newip((ipidx(2)+1):end);
      skt.remoteip=skt.ip;
    endif
    if (max(size(find(skt.ip=='.')))==3)
      sktclose(skt);
      skt=sktopen(newip);
      if(isunix)
       system(["ping -c 4 " newip]);
      else
       system(["ping  " newip]);
      end
     end
endfunction


function u=ip2uint8(ip)
%function u=ip2uint8(ip)
a=find(ip=='.');
ip(a)=ones(size(a))*' ';
eval(['u=[' ip '];']);
u=uint8(u);
endfunction


